import 'package:photogram_admin_cp/ui/components/layout.dart';
import 'package:photogram_admin_cp/ui/pages/content/storage/aws.dart';
import 'package:photogram_admin_cp/ui/pages/content/storage/azure.dart';
import 'package:photogram_admin_cp/ui/pages/content/storage/disks.dart';
import 'package:photogram_admin_cp/ui/pages/content/storage/wasabi.dart';
import 'package:rad/rad.dart';
import 'package:rad/widgets_html.dart';

import 'package:photogram_admin_cp/import/core.dart';

class StorageOptionsPage extends StatefulWidget {
  const StorageOptionsPage({Key? key}) : super(key: key);

  @override
  _StorageOptionsState createState() => _StorageOptionsState();
}

class _StorageOptionsState extends State<StorageOptionsPage> with AppActiveContentMixin {
  NavigatorState? _state;
  String _currentRoute = 'disks';

  @override
  build(context) {
    return PageRow(
      children: [
        Division(
          className: 'col-lg-6',
          child: navigatorContent(),
        ),
        Division(
          className: 'col-lg-3',
          children: [
            Division(
              className: 'content-sidebar',
              children: [
                Division(
                  className: 'on-this-page-nav',
                  children: [
                    const Division(className: 'title font-size-18', innerText: 'Control Panel'),
                    Anchor(
                      className: _currentRoute == 'disks' ? 'active' : '',
                      innerText: 'Activate/Deactivate Disks',
                      onClick: (_) => _openRoute('disks'),
                    ),
                  ],
                ),
                const LineBreak(),
                Division(
                  className: 'on-this-page-nav',
                  children: [
                    const Division(className: 'title font-size-18', innerText: 'Cloud Storage Disks'),
                    Anchor(
                      className: _currentRoute == 'wasabi' ? 'active' : '',
                      innerText: 'Wasabi S3',
                      onClick: (_) => _openRoute('wasabi'),
                    ),
                    Anchor(
                      className: _currentRoute == 'azure' ? 'active' : '',
                      innerText: 'Microsoft Azure Blob',
                      onClick: (_) => _openRoute('azure'),
                    ),
                    Anchor(
                      className: _currentRoute == 'aws' ? 'active' : '',
                      innerText: 'Amazon Web Services S3',
                      onClick: (_) => _openRoute('aws'),
                    ),
                  ],
                ),
              ],
            ),
          ],
        ),
      ],
    );
  }

  Widget navigatorContent() {
    return Navigator(
      key: const Key('storage-options-navigator'),
      onInit: (state) => _state = state,
      onRouteChange: _onRouteChange,
      routes: const [
        Route(name: 'disks', page: DisksSection()),
        Route(name: 'wasabi', page: WasabiSection()),
        Route(name: 'azure', page: AzureSection()),
        Route(name: 'aws', page: AwsSection()),
      ],
    );
  }

  void _openRoute(String name, [Map<String, String> values = const {}]) {
    _state?.open(name: name, values: values);
  }

  void _onRouteChange(String name) {
    Future.delayed(Duration.zero, () {
      setState(() {
        _currentRoute = name;
      });
    });
  }
}
